
include(util)

if (EXISTS "${PROJECT_SOURCE_DIR}/version_override.cmake")
    # This allows to override the values by using a special file
    include("${PROJECT_SOURCE_DIR}/version_override.cmake")
endif()

set_if_not_defined(FSO_VERSION_MAJOR 24)
set_if_not_defined(FSO_VERSION_MINOR 3)
set_if_not_defined(FSO_VERSION_BUILD 0)

# A numeric revision e.g. the CI build number
set_if_not_defined(FSO_VERSION_REVISION 0)

# A generic revision string, can be anything
set_if_not_defined(FSO_VERSION_REVISION_STR "${FSO_VERSION_REVISION}")

if("${FSO_VERSION_REVISION}" STREQUAL "0" AND "${FSO_VERSION_REVISION_STR}" STREQUAL "${FSO_VERSION_REVISION}")
    set(FSO_VERSION_HAS_REVISION 0)
else()
    set(FSO_VERSION_HAS_REVISION 1)
endif()

set(FSO_FULL_VERSION_STRING "${FSO_VERSION_MAJOR}.${FSO_VERSION_MINOR}.${FSO_VERSION_BUILD}")
set(FSO_PRODUCT_VERSION_STRING "${FSO_FULL_VERSION_STRING}")

if (FSO_VERSION_HAS_REVISION)
    set(FSO_FULL_VERSION_STRING "${FSO_FULL_VERSION_STRING}.${FSO_VERSION_REVISION_STR}")
endif()

IF(NOT FSO_VERSION_HAS_REVISION)
    SET(FSO_BINARY_SUFFIX "${FSO_VERSION_MAJOR}_${FSO_VERSION_MINOR}_${FSO_VERSION_BUILD}")
ELSE()
    SET(FSO_BINARY_SUFFIX "${FSO_VERSION_MAJOR}_${FSO_VERSION_MINOR}_${FSO_VERSION_BUILD}_${FSO_VERSION_REVISION_STR}")
ENDIF()

IF(IS_RISCV)
	IF(IS_64BIT)
		SET(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}_riscv64")
	ELSE()
		SET(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}_riscv32")
	ENDIF()
ELSEIF(IS_ARM64)
    SET(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}_arm64")
ELSEIF(IS_64BIT)
	# This is a 64-bit builds
    SET(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}_x64")
ENDIF()

IF (NOT "${FSO_INSTRUCTION_SET}" STREQUAL "")
    SET(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}_${FSO_INSTRUCTION_SET}")
ENDIF()

IF (NOT "${FSO_BUILD_POSTFIX}" STREQUAL "")
    SET(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}_${FSO_BUILD_POSTFIX}")
ENDIF()

set(CONFIG_POSTFIX "$<$<CONFIG:Release>:>$<$<CONFIG:Debug>:-DEBUG>$<$<CONFIG:FastDebug>:-FASTDBG>")
set(FSO_BINARY_SUFFIX "${FSO_BINARY_SUFFIX}${CONFIG_POSTFIX}")
