
#include "hook_api.h"
#include "scripting/hook_conditions.h"

namespace scripting {
namespace hooks {

extern const std::shared_ptr<Hook<>>									OnGameInit;
extern const std::shared_ptr<Hook<>>									OnSplashEnd;
extern const std::shared_ptr<OverridableHook<>>							OnIntroAboutToPlay;
extern const std::shared_ptr<OverridableHook<>>							OnMovieAboutToPlay;
extern const std::shared_ptr<Hook<>>									OnOptionsTabChanged;
extern const std::shared_ptr<Hook<>>									OnOptionsMenuClosed;
extern const std::shared_ptr<Hook<>>									OnHUDConfigMenuClosed;
extern const std::shared_ptr<Hook<>>									OnControlConfigMenuClosed;
//The On State Start hook previously used to pass OldState to the conditions, but no semantically sensible condition read the value, so we pretend it has no local condition
extern const std::shared_ptr<OverridableHook<>>							OnStateStart;

extern const std::shared_ptr<Hook<>>									OnLoadScreen;
extern const std::shared_ptr<Hook<>>									OnLoadComplete;
extern const std::shared_ptr<Hook<>>									OnCampaignMissionAccept;
extern const std::shared_ptr<Hook<>>									OnBriefStage;
extern const std::shared_ptr<Hook<>>									OnMissionStart; 
extern const std::shared_ptr<Hook<>>									OnGameplayStart;

extern const std::shared_ptr<Hook<ControlActionConditions>>				OnAction;
extern const std::shared_ptr<Hook<ControlActionConditions>>				OnActionStopped;
extern const std::shared_ptr<OverridableHook<KeyPressConditions>>		OnKeyPressed;
extern const std::shared_ptr<Hook<KeyPressConditions>>					OnKeyReleased;
extern const std::shared_ptr<Hook<>>									OnMouseMoved;
extern const std::shared_ptr<Hook<>>									OnMousePressed;
extern const std::shared_ptr<Hook<>>									OnMouseReleased;

extern const std::shared_ptr<Hook<ShipSourceConditions>>				OnAfterburnerStart;
extern const std::shared_ptr<Hook<ShipSourceConditions>>				OnAfterburnerEnd;
extern const std::shared_ptr<Hook<ShipSourceConditions>>				OnWaypointsDone;
extern const std::shared_ptr<Hook<ShipSourceConditions>>				OnGoalsCleared;

extern const std::shared_ptr<Hook<ShipSourceConditions>>				OnDebrisCreated;
extern const std::shared_ptr<Hook<>>									OnAsteroidCreated;

extern const std::shared_ptr<OverridableHook<CollisionConditions>>		OnShipCollision;
extern const std::shared_ptr<OverridableHook<CollisionConditions>>		OnWeaponCollision;
extern const std::shared_ptr<OverridableHook<CollisionConditions>>		OnBeamCollision;
extern const std::shared_ptr<OverridableHook<CollisionConditions>>		OnDebrisCollision;
extern const std::shared_ptr<OverridableHook<CollisionConditions>>		OnAsteroidCollision;

extern const std::shared_ptr<Hook<ShipArriveConditions>>					OnShipArrive;
extern const std::shared_ptr<Hook<WeaponCreatedConditions>>				OnWeaponCreated;

extern const std::shared_ptr<Hook<ShipDeathConditions>>					OnShipDeathStarted;
extern const std::shared_ptr<OverridableHook<ShipDeathConditions>>		OnShipDeath;
extern const std::shared_ptr<Hook<WeaponDeathConditions>>				OnMissileDeathStarted;
extern const std::shared_ptr<Hook<WeaponDeathConditions>>				OnMissileDeath;
extern const std::shared_ptr<Hook<>>									OnBeamDeath;
extern const std::shared_ptr<Hook<>>									OnAsteroidDeath;
extern const std::shared_ptr<Hook<>>									OnDebrisDeath;
extern const std::shared_ptr<Hook<SubsystemDeathConditions>>			OnSubsystemDestroyed;

extern const std::shared_ptr<Hook<ShipDepartConditions>>				OnShipDepart;
extern const std::shared_ptr<Hook<WeaponDeathConditions>>				OnWeaponDelete;

extern const std::shared_ptr<Hook<WeaponEquippedConditions>>			OnWeaponEquipped;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnWeaponFired;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnPrimaryFired;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnSecondaryFired;
extern const std::shared_ptr<Hook<WeaponSelectedConditions>>			OnWeaponSelected;
extern const std::shared_ptr<Hook<WeaponDeselectedConditions>>			OnWeaponDeselected;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnTurretFired;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnBeamWarmup;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnBeamFired;
extern const std::shared_ptr<Hook<WeaponUsedConditions>>				OnBeamWarmdown;

extern const std::shared_ptr<OverridableHook<>>							OnHudCommMenuOpened;
extern const std::shared_ptr<OverridableHook<>>							OnHudCommMenuClosed;
extern const std::shared_ptr<OverridableHook<CommOrderConditions>> OnHudCommOrderIssued;

extern const std::shared_ptr<OverridableHook<ObjectDrawConditions>>		OnHudDraw;
extern const std::shared_ptr<OverridableHook<ObjectDrawConditions>>		OnObjectRender;
extern const std::shared_ptr<Hook<>>									OnSimulation;


extern const std::shared_ptr<OverridableHook<>>							OnDialogInit;
extern const std::shared_ptr<OverridableHook<>>							OnDialogFrame;
extern const std::shared_ptr<Hook<>>									OnDialogClose;

extern const std::shared_ptr<Hook<>>									OnCheat;

extern const std::shared_ptr<OverridableHook<>>                         OnMissionGoalStatusChanged;

extern const std::shared_ptr<Hook<>>									OnMissionAboutToEndHook;
extern const std::shared_ptr<OverridableHook<>>							OnMissionEndHook;
extern const std::shared_ptr<Hook<>>									OnStateAboutToEndHook;
extern const std::shared_ptr<OverridableHook<>>							OnStateEndHook;
extern const std::shared_ptr<Hook<>>									OnCameraSetUpHook;

// FRED Hooks
extern const std::shared_ptr<Hook<>>                                    FredOnMissionLoad;
extern const std::shared_ptr<Hook<>>									FredOnMissionSpecsSave;

// deprecated
extern const std::shared_ptr<OverridableHook<>>							OnSplashScreen;
extern const std::shared_ptr<OverridableHook<ObjectDeathConditions>>	OnDeath;

}
} // namespace scripting