/* Copyright (C) 2021-2022 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import React from 'react';

import styled from 'styled-components';

import compose from 'web/utils/compose';
import PropTypes from 'web/utils/proptypes';
import Theme from 'web/utils/theme';

import withLayout from 'web/components/layout/withLayout';

const StyledButton = styled.button`
  display: inline-block;
  padding: 5px 7px;
  margin-top: -5px;
  color: ${Theme.darkGray};
  text-align: center;
  vertical-align: middle;
  font-size: 11px;
  font-weight: bold;
  text-decoration: none;
  white-space: nowrap;
  background-color: ${Theme.white};
  border-radius: 2px;
  border: 1px solid ${Theme.inputBorderGray};
  cursor: pointer;
  overflow: visible;
  z-index: ${Theme.Layers.higher}; /* Don't interfere with dialog resizer */
  &:focus,
  &:hover {
    border: 1px solid ${Theme.darkGray};
  }
  &:hover {
    text-decoration: none;
    background: ${Theme.mediumBlue};
    font-weight: bold;
    color: ${Theme.white};
  }
  &[disabled] {
    cursor: not-allowed;
    opacity: 0.65;
    box-shadow: none;
  }
  &:link {
    text-decoration: none;
    color: ${Theme.darkGray};
  }
`;

const Button = ({title, children = title, ...other}) => (
  <StyledButton {...other} title={title}>
    {children}
  </StyledButton>
);

Button.propTypes = {
  title: PropTypes.string,
};

export default compose(
  withLayout({align: ['center', 'center']}),
  // withClickHandler(),
)(Button);

// vim: set ts=2 sw=2 tw=80:
