/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceMergeActionHandler;
import org.eclipse.team.internal.ui.mapping.ResourceModelProviderOperation;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ResourceMergeHandler
extends ResourceMergeActionHandler {
    private final boolean overwrite;
    private ResourceModelProviderOperation operation;

    public ResourceMergeHandler(ISynchronizePageConfiguration configuration, boolean overwrite) {
        super(configuration);
        this.overwrite = overwrite;
    }

    protected synchronized SynchronizationOperation getOperation() {
        if (this.operation == null) {
            this.operation = new ResourceModelProviderOperation(this.getConfiguration(), this.getStructuredSelection()){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IStatus status;
                        IMergeContext context = (IMergeContext)this.getContext();
                        IDiff[] diffs = this.getTargetDiffs();
                        if (diffs.length == 0) {
                            ResourceMergeHandler.this.promptForNoChanges();
                        }
                        if (!(status = context.merge(diffs, ResourceMergeHandler.this.overwrite, monitor)).isOK()) {
                            throw new CoreException(status);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }

                protected FastDiffFilter getDiffFilter() {
                    return new FastDiffFilter(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean select(IDiff node) {
                            if (node instanceof IThreeWayDiff) {
                                IThreeWayDiff twd = (IThreeWayDiff)node;
                                return twd.getDirection() == 256 && ResourceMergeHandler.access$0(1.access$0(this.this$1)) || twd.getDirection() == 768 || twd.getDirection() == 512;
                            }
                            return ResourceMergeHandler.access$0(1.access$0(this.this$1));
                        }
                    };
                }

                protected String getJobName() {
                    IDiff[] diffs = this.getTargetDiffs();
                    if (ResourceMergeHandler.this.overwrite) {
                        if (diffs.length == 1) {
                            return TeamUIMessages.ResourceMergeHandler_0;
                        }
                        return NLS.bind((String)TeamUIMessages.ResourceMergeHandler_1, (Object)new Integer(diffs.length).toString());
                    }
                    if (diffs.length == 1) {
                        return TeamUIMessages.ResourceMergeHandler_2;
                    }
                    return NLS.bind((String)TeamUIMessages.ResourceMergeHandler_3, (Object)new Integer(diffs.length).toString());
                }

                static /* synthetic */ ResourceMergeHandler access$0(1 var0) {
                    return var0.ResourceMergeHandler.this;
                }
            };
        }
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnablement(IStructuredSelection selection) {
        ResourceMergeHandler resourceMergeHandler = this;
        synchronized (resourceMergeHandler) {
            this.operation = null;
        }
        super.updateEnablement(selection);
        int mode = this.getConfiguration().getMode();
        if (mode == 2 && !this.overwrite) {
            this.setEnabled(false);
            return;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.saveDirtyEditors() && (!this.overwrite || this.promptToConfirm())) {
            return super.execute(event);
        }
        return null;
    }

    protected boolean promptToConfirm() {
        if (Display.getCurrent() != null) {
            return this.internalPromptToConfirm();
        }
        final boolean[] confirmed = new boolean[1];
        Shell shell = this.getConfiguration().getSite().getShell();
        if (!shell.isDisposed()) {
            Utils.syncExec(new Runnable(){

                public void run() {
                    confirmed[0] = ResourceMergeHandler.this.promptToConfirm();
                }
            }, (Control)shell);
        }
        return confirmed[0];
    }

    private boolean internalPromptToConfirm() {
        return MessageDialog.openQuestion((Shell)this.getConfiguration().getSite().getShell(), (String)TeamUIMessages.ResourceMergeHandler_4, (String)TeamUIMessages.ResourceMergeHandler_5);
    }

    protected void promptForNoChanges() {
        Utils.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)ResourceMergeHandler.this.getConfiguration().getSite().getShell(), (String)TeamUIMessages.ResourceMergeHandler_6, (String)TeamUIMessages.ResourceMergeHandler_7);
            }
        }, (StructuredViewer)this.getConfiguration().getPage().getViewer());
    }
}

