/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.subsystems;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;

public class SubSystemPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.toLowerCase().equals("hassubsystemcategory")) {
            boolean test = (Boolean)expectedValue;
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)((IAdaptable)receiver).getAdapter(ISystemViewElementAdapter.class);
            if (adapter != null) {
                ISubSystem subsystem = adapter.getSubSystem(receiver);
                if (subsystem != null) {
                    IHost host = subsystem.getHost();
                    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                    String category = (String)args[0];
                    ISubSystemConfigurationProxy[] proxies = registry.getSubSystemConfigurationProxiesByCategory(category);
                    int i = 0;
                    while (i < proxies.length) {
                        if (proxies[i].appliesToSystemType(host.getSystemType())) {
                            return test;
                        }
                        ++i;
                    }
                }
                return !test;
            }
            return !test;
        }
        if (property.toLowerCase().equals("isoffline")) {
            boolean test = (Boolean)expectedValue;
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)((IAdaptable)receiver).getAdapter(ISystemViewElementAdapter.class);
            if (adapter != null) {
                ISubSystem subsystem = adapter.getSubSystem(receiver);
                if (subsystem != null && subsystem.isOffline()) {
                    return test;
                }
                return !test;
            }
            return !test;
        }
        return false;
    }
}

