/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc.document;

import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.document.MemTreeNode;

public class MemTOCWriter
implements ITOCWriter,
ITOCConstants {
    private MemTreeNode rootNode = new MemTreeNode();

    public MemTOCWriter() {
        this.rootNode.setNodeId("/");
    }

    @Override
    public void close() {
    }

    @Override
    public ITreeNode getTree() {
        return this.rootNode;
    }

    @Override
    public void startTOCEntry(TOCEntry entry) {
        MemTreeNode treeNode = new MemTreeNode(entry);
        entry.setTreeNode(treeNode);
        MemTreeNode parentTreeNode = this.getParentTreeNode(entry);
        parentTreeNode.addChild(treeNode);
    }

    MemTreeNode getParentTreeNode(TOCEntry entry) {
        TOCEntry parent = entry.getParent();
        if (parent != null) {
            return (MemTreeNode)parent.getTreeNode();
        }
        return this.rootNode;
    }

    @Override
    public void closeTOCEntry(TOCEntry entry) {
    }
}

