/*****************************************************************************
 * Copyright (c) 2014-2023 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "VehicleData.h"

#include <iterator>

// clang-format off
/** rct2: 0x0099F100 */
static constexpr const uint8_t Rotation1TimeToSpriteMap_0[] = {
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
    1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
    2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
    3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
    4,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,
    6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,
    7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
    9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,
    10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,
    13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,
    15,  15,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,
    19,  19,  19,  19,  19,  20,  20,  20,  20,  21,  21,  21,  21,  22,  22,  22,  22,
    23,  23,  23,  23,  24,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  27,  28,
    28,  28,  29,  29,  29,  30,  30,  30,  31,  31,  31,  32,  32,  32,  33,  33,  33,
    34,  34,  34,  35,  35,  35,  36,  36,  36,  37,  37,  37,  38,  38,  38,  39,  39,
    39,  40,  40,  40,  41,  41,  41,  42,  42,  42,  43,  43,  43,  44,  44,  44,  45,
    45,  45,  46,  46,  46,  47,  47,  47,  48,  48,  48,  49,  49,  49,  50,  50,  50,
    51,  51,  51,  52,  52,  52,  53,  53,  53,  54,  54,  54,  55,  55,  55,  56,  56,
    56,  57,  57,  57,  58,  58,  58,  59,  59,  59,  60,  60,  60,  61,  61,  61,  62,
    62,  62,  63,  63,  63,  64,  64,  64,  65,  65,  65,  66,  66,  66,  67,  67,  67,
    68,  68,  68,  69,  69,  69,  70,  70,  70,  71,  71,  71,  72,  72,  72,  73,  73,
    73,  74,  74,  74,  75,  75,  75,  76,  76,  76,  77,  77,  77,  78,  78,  78,  79,
    79,  79,  80,  80,  80,  81,  81,  81,  82,  82,  82,  83,  83,  83,  84,  84,  84,
    85,  85,  85,  86,  86,  86,  87,  87,  87,  88,  88,  88,  89,  89,  89,  90,  90,
    90,  91,  91,  91,  92,  92,  92,  93,  93,  93,  94,  94,  94,  95,  95,  95,  96,
    96,  96,  97,  97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101,
    102, 102, 102, 103, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 106, 107, 107,
    107, 108, 108, 108, 109, 109, 109, 110, 110, 110, 111, 111, 111, 112, 112, 112, 113,
    113, 113, 114, 114, 114, 115, 115, 115, 116, 116, 116, 117, 117, 117, 118, 118, 118,
    119, 119, 119, 120, 120, 120, 121, 121, 121, 122, 122, 122, 123, 123, 123, 124, 124,
    124, 125, 125, 125, 126, 126, 126, 127, 127, 127, 128, 128, 128, 129, 129, 129, 130,
    130, 130, 131, 131, 131, 132, 132, 132, 133, 133, 133, 134, 134, 134, 135, 135, 135,
    136, 136, 136, 137, 137, 137, 138, 138, 138, 139, 139, 139, 140, 140, 140, 141, 141,
    141, 142, 142, 142, 143, 143, 143, 144, 144, 144, 145, 145, 145, 146, 146, 146, 147,
    147, 147, 148, 148, 148, 149, 149, 149, 150, 150, 150, 151, 151, 151, 152, 152, 152,
    153, 153, 153, 154, 154, 154, 155, 155, 155, 156, 156, 156, 157, 157, 157, 158, 158,
    158, 159, 159, 159, 160, 160, 160, 161, 161, 161, 162, 162, 162, 163, 163, 163, 164,
    164, 164, 165, 165, 165, 166, 166, 166, 167, 167, 167, 168, 168, 168, 169, 169, 169,
    170, 170, 170, 171, 171, 171, 172, 172, 172, 173, 173, 173, 174, 174, 174, 175, 175,
    175, 176, 176, 176, 177, 177, 177, 178, 178, 178, 179, 179, 179, 180, 180, 180, 181,
    181, 181, 182, 182, 182, 183, 183, 183, 184, 184, 184, 185, 185, 185, 186, 186, 186,
    187, 187, 187, 188, 188, 188, 189, 189, 189, 190, 190, 190, 191, 191, 191, 192, 192,
    192, 193, 193, 193, 194, 194, 194, 195, 195, 195, 196, 196, 196, 197, 197, 197, 198,
    198, 198, 199, 199, 199, 200, 200, 200, 201, 201, 201, 202, 202, 202, 203, 203, 203,
    204, 204, 204, 205, 205, 205, 206, 206, 206, 207, 207, 207, 208, 208, 208, 209, 209,
    209, 210, 210, 210, 211, 211, 211, 212, 212, 212, 213, 213, 213, 214, 214, 214, 215,
    215, 215,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x0099F422 */
static constexpr const uint8_t Rotation1TimeToSpriteMap_1[] = {
    0,   0,   0,   1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,
    5,   6,   6,   6,   7,   7,   7,   8,   8,   8,   9,   9,   9,  10,  10,  10,  11,
    11,  11,  12,  12,  12,  13,  13,  13,  14,  14,  14,  15,  15,  15,  16,  16,  16,
    17,  17,  17,  18,  18,  18,  19,  19,  19,  20,  20,  20,  21,  21,  21,  22,  22,
    22,  23,  23,  23,  24,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  27,  28,
    28,  28,  29,  29,  29,  30,  30,  30,  31,  31,  31,  32,  32,  32,  33,  33,  33,
    34,  34,  34,  35,  35,  35,  36,  36,  36,  37,  37,  37,  38,  38,  38,  39,  39,
    39,  40,  40,  40,  41,  41,  41,  42,  42,  42,  43,  43,  43,  44,  44,  44,  45,
    45,  45,  46,  46,  46,  47,  47,  47,  48,  48,  48,  49,  49,  49,  50,  50,  50,
    51,  51,  51,  52,  52,  52,  53,  53,  53,  54,  54,  54,  55,  55,  55,  56,  56,
    56,  57,  57,  57,  58,  58,  58,  59,  59,  59,  60,  60,  60,  61,  61,  61,  62,
    62,  62,  63,  63,  63,  64,  64,  64,  65,  65,  65,  66,  66,  66,  67,  67,  67,
    68,  68,  68,  69,  69,  69,  70,  70,  70,  71,  71,  71,  72,  72,  72,  73,  73,
    73,  74,  74,  74,  75,  75,  75,  76,  76,  76,  77,  77,  77,  78,  78,  78,  79,
    79,  79,  80,  80,  80,  81,  81,  81,  82,  82,  82,  83,  83,  83,  84,  84,  84,
    85,  85,  85,  86,  86,  86,  87,  87,  87,  88,  88,  88,  89,  89,  89,  90,  90,
    90,  91,  91,  91,  92,  92,  92,  93,  93,  93,  94,  94,  94,  95,  95,  95,  96,
    96,  96,  97,  97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101,
    102, 102, 102, 103, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 106, 107, 107,
    107, 108, 108, 108, 109, 109, 109, 110, 110, 110, 111, 111, 111, 112, 112, 112, 113,
    113, 113, 114, 114, 114, 115, 115, 115, 116, 116, 116, 117, 117, 117, 118, 118, 118,
    119, 119, 119, 120, 120, 120, 121, 121, 121, 122, 122, 122, 123, 123, 123, 124, 124,
    124, 125, 125, 125, 126, 126, 126, 127, 127, 127, 128, 128, 128, 129, 129, 129, 130,
    130, 130, 131, 131, 131, 132, 132, 132, 133, 133, 133, 134, 134, 134, 135, 135, 135,
    136, 136, 136, 137, 137, 137, 138, 138, 138, 139, 139, 139, 140, 140, 140, 141, 141,
    141, 142, 142, 142, 143, 143, 143, 144, 144, 144, 145, 145, 145, 146, 146, 146, 147,
    147, 147, 148, 148, 148, 149, 149, 149, 150, 150, 150, 151, 151, 151, 152, 152, 152,
    153, 153, 153, 154, 154, 154, 155, 155, 155, 156, 156, 156, 157, 157, 157, 158, 158,
    158, 159, 159, 159, 160, 160, 160, 161, 161, 161, 162, 162, 162, 163, 163, 163, 164,
    164, 164, 165, 165, 165, 166, 166, 166, 167, 167, 167, 168, 168, 168, 169, 169, 169,
    170, 170, 170, 171, 171, 171, 172, 172, 172, 173, 173, 173, 174, 174, 174, 175, 175,
    175, 176, 176, 176, 177, 177, 177, 178, 178, 178, 179, 179, 179, 180, 180, 180, 181,
    181, 181, 182, 182, 182, 183, 183, 183, 184, 184, 184, 185, 185, 185, 186, 186, 186,
    187, 187, 187, 188, 188, 188, 189, 189, 189, 190, 190, 190, 191, 191, 191, 192, 192,
    192, 193, 193, 193, 194, 194, 194, 195, 195, 195, 196, 196, 196, 197, 197, 197, 198,
    198, 198, 199, 199, 199, 200, 200, 200, 201, 201, 201, 202, 202, 202, 203, 203, 203,
    204, 204, 204, 205, 205, 205, 206, 206, 206, 207, 207, 207, 208, 208, 208, 209, 209,
    209, 210, 210, 210, 211, 211, 211, 212, 212, 212, 213, 213, 213, 214, 214, 214, 215,
    215, 215,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x0099F6AB */
static constexpr const uint8_t Rotation1TimeToSpriteMap_2[] = {
    0,   0,   0,   1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,
    5,   6,   6,   6,   7,   7,   7,   8,   8,   8,   9,   9,   9,  10,  10,  10,  11,
    11,  11,  12,  12,  12,  13,  13,  13,  14,  14,  14,  15,  15,  15,  16,  16,  16,
    17,  17,  17,  18,  18,  18,  19,  19,  19,  20,  20,  20,  21,  21,  21,  22,  22,
    22,  23,  23,  23,  24,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  27,  28,
    28,  28,  29,  29,  29,  30,  30,  30,  31,  31,  31,  32,  32,  32,  33,  33,  33,
    34,  34,  34,  35,  35,  35,  36,  36,  36,  37,  37,  37,  38,  38,  38,  39,  39,
    39,  40,  40,  40,  41,  41,  41,  42,  42,  42,  43,  43,  43,  44,  44,  44,  45,
    45,  45,  46,  46,  46,  47,  47,  47,  48,  48,  48,  49,  49,  49,  50,  50,  50,
    51,  51,  51,  52,  52,  52,  53,  53,  53,  54,  54,  54,  55,  55,  55,  56,  56,
    56,  57,  57,  57,  58,  58,  58,  59,  59,  59,  60,  60,  60,  61,  61,  61,  62,
    62,  62,  63,  63,  63,  64,  64,  64,  65,  65,  65,  66,  66,  66,  67,  67,  67,
    68,  68,  68,  69,  69,  69,  70,  70,  70,  71,  71,  71,  72,  72,  72,  73,  73,
    73,  74,  74,  74,  75,  75,  75,  76,  76,  76,  77,  77,  77,  78,  78,  78,  79,
    79,  79,  80,  80,  80,  81,  81,  81,  82,  82,  82,  83,  83,  83,  84,  84,  84,
    85,  85,  85,  86,  86,  86,  87,  87,  87,  88,  88,  88,  89,  89,  89,  90,  90,
    90,  91,  91,  91,  92,  92,  92,  93,  93,  93,  94,  94,  94,  95,  95,  95,  96,
    96,  96,  97,  97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101,
    102, 102, 102, 103, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 106, 107, 107,
    107, 108, 108, 108, 109, 109, 109, 110, 110, 110, 111, 111, 111, 112, 112, 112, 113,
    113, 113, 114, 114, 114, 115, 115, 115, 116, 116, 116, 117, 117, 117, 118, 118, 118,
    119, 119, 119, 120, 120, 120, 121, 121, 121, 122, 122, 122, 123, 123, 123, 124, 124,
    124, 125, 125, 125, 126, 126, 126, 127, 127, 127, 128, 128, 128, 129, 129, 129, 130,
    130, 130, 131, 131, 131, 132, 132, 132, 133, 133, 133, 134, 134, 134, 135, 135, 135,
    136, 136, 136, 137, 137, 137, 138, 138, 138, 139, 139, 139, 140, 140, 140, 141, 141,
    141, 142, 142, 142, 143, 143, 143, 144, 144, 144, 145, 145, 145, 146, 146, 146, 147,
    147, 147, 148, 148, 148, 149, 149, 149, 150, 150, 150, 151, 151, 151, 152, 152, 152,
    153, 153, 153, 154, 154, 154, 155, 155, 155, 156, 156, 156, 157, 157, 157, 158, 158,
    158, 159, 159, 159, 160, 160, 160, 161, 161, 161, 162, 162, 162, 163, 163, 163, 164,
    164, 164, 165, 165, 165, 166, 166, 166, 167, 167, 167, 168, 168, 168, 169, 169, 169,
    170, 170, 170, 171, 171, 171, 172, 172, 172, 173, 173, 173, 174, 174, 174, 175, 175,
    175, 176, 176, 176, 177, 177, 177, 178, 178, 178, 179, 179, 179, 180, 180, 180, 181,
    181, 181, 182, 182, 182, 183, 183, 183, 184, 184, 184, 185, 185, 185, 186, 186, 186,
    187, 187, 187, 188, 188, 188, 189, 189, 189, 190, 190, 190, 191, 191, 191, 191, 191,
    191, 191, 192, 192, 192, 192, 193, 193, 193, 193, 194, 194, 194, 194, 195, 195, 195,
    195, 195, 196, 196, 196, 196, 196, 197, 197, 197, 197, 197, 198, 198, 198, 198, 198,
    199, 199, 199, 199, 199, 199, 200, 200, 200, 200, 200, 200, 201, 201, 201, 201, 201,
    201, 201, 202, 202, 202, 202, 202, 202, 202, 203, 203, 203, 203, 203, 203, 203, 203,
    204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 205, 205, 205, 205, 205,
    205, 205, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 207, 207, 207, 207,
    207, 207, 207, 207, 207, 207, 207, 207, 208, 208, 208, 208, 208, 208, 208, 208, 208,
    208, 208, 208, 208, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209, 209,
    209, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 210, 211,
    211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 212, 212,
    212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 213, 213,
    213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 214,
    214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214,
    214, 214,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x0099F0F4 */
const uint8_t * Rotation1TimeToSpriteMaps[] = {
    Rotation1TimeToSpriteMap_0,
    Rotation1TimeToSpriteMap_1,
    Rotation1TimeToSpriteMap_2,
};

/** rct2: 0x009A2434 */
static constexpr const uint8_t Rotation2TimeToSpriteMap_0[] = {
    0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   2,
    2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,
    4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,
    6,   6,   6,   6,   6,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,
    4,   4,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   3,
    3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   5,
    6,   6,   6,   6,   6,   6,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   5,
    5,   5,   5,   5,   6,   6,   6,   6,   6,   3,   3,   3,   3,   4,   4,   4,   4,
    5,   5,   5,   5,   6,   6,   6,   6,   7,   7,   7,   7,   8,   8,   8,   8,   9,
    9,   9,   9,   7,   7,   7,   7,   8,   8,   8,   8,   9,   9,   9,   9,   7,   7,
    7,   7,   8,   8,   8,   8,   9,   9,   9,   9,   7,   7,   7,   7,   8,   8,   8,
    8,   9,   9,   9,   9,   7,   7,   7,   7,   8,   8,   8,   8,   9,   9,   9,   9,
    10,  10,  10,  11,  11,  11,  12,  12,  12,  10,  10,  10,  11,  11,  11,  12,  12,
    12,  10,  10,  10,  11,  11,  11,  12,  12,  12,  10,  10,  10,  11,  11,  11,  12,
    12,  12,  13,  13,  13,  14,  14,  14,  15,  15,  15,  13,  13,  13,  14,  14,  14,
    15,  15,  15,  13,  13,  13,  14,  14,  14,  15,  15,  15,  13,  13,  13,  14,  14,
    14,  15,  15,  15,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,
    16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,
    16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,
    18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,
    18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,
    17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,
    17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,
    16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,
    16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,
    18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,
    18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  19,  19,  20,
    20,  21,  21,  19,  19,  20,  20,  21,  21,  19,  19,  20,  20,  21,  21,  22,  22,
    23,  23,  24,  24,  22,  22,  23,  23,  24,  24,  22,  22,  23,  23,  24,  24,  25,
    25,  26,  26,  27,  27,  25,  25,  26,  26,  27,  27,  25,  25,  26,  26,  27,  27,
    28,  28,  29,  29,  30,  30,  28,  28,  29,  29,  30,  30,  28,  28,  29,  29,  30,
    30,  31,  31,  32,  32,  33,  33,  31,  31,  32,  32,  33,  33,  31,  31,  32,  32,
    33,  33,  34,  34,  35,  35,  36,  36,  34,  34,  35,  35,  36,  36,  34,  34,  35,
    35,  36,  36,  37,  37,  38,  38,  39,  39,  37,  37,  38,  38,  39,  39,  37,  37,
    38,  38,  39,  39,  40,  40,  41,  41,  42,  42,  40,  40,  41,  41,  42,  42,  40,
    40,  41,  41,  42,  42,  43,  43,  44,  44,  45,  45,  43,  43,  44,  44,  45,  45,
    43,  43,  44,  44,  45,  45,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x009A26A6 */
static constexpr const uint8_t Rotation2TimeToSpriteMap_1[] = {
    46,  46,  47,  47,  48,  48,  46,  46,  47,  47,  48,  48,  46,  46,  47,  47,  48,
    48,  46,  46,  47,  47,  48,  48,  46,  46,  47,  47,  48,  48,  46,  46,  47,  47,
    48,  48,  46,  46,  47,  47,  48,  48,  46,  46,  47,  47,  48,  48,  46,  46,  47,
    47,  48,  48,  46,  46,  47,  47,  48,  48,  46,  46,  47,  47,  48,  48,  46,  46,
    47,  47,  48,  48,  46,  46,  47,  47,  48,  48,  46,  46,  47,  47,  48,  48,  46,
    46,  47,  47,  48,  48,  46,  46,  47,  47,  48,  48,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x009A270E */
static constexpr const uint8_t Rotation2TimeToSpriteMap_2[] = {
    43,  43,  44,  44,  45,  45,  43,  43,  44,  44,  45,  45,  43,  43,  44,  44,  45,
    45,  40,  40,  41,  41,  42,  42,  40,  40,  41,  41,  42,  42,  40,  40,  41,  41,
    42,  42,  37,  37,  38,  38,  39,  39,  37,  37,  38,  38,  39,  39,  37,  37,  38,
    38,  39,  39,  34,  34,  35,  35,  36,  36,  34,  34,  35,  35,  36,  36,  34,  34,
    35,  35,  36,  36,  31,  31,  32,  32,  33,  33,  31,  31,  32,  32,  33,  33,  31,
    31,  32,  32,  33,  33,  28,  28,  29,  29,  30,  30,  28,  28,  29,  29,  30,  30,
    28,  28,  29,  29,  30,  30,  25,  25,  26,  26,  27,  27,  25,  25,  26,  26,  27,
    27,  25,  25,  26,  26,  27,  27,  22,  22,  23,  23,  24,  24,  22,  22,  23,  23,
    24,  24,  22,  22,  23,  23,  24,  24,  19,  19,  20,  20,  21,  21,  19,  19,  20,
    20,  21,  21,  19,  19,  20,  20,  21,  21,  16,  16,  17,  17,  18,  18,  16,  16,
    17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,  16,  17,  17,  18,  18,  16,
    16,  17,  17,  18,  18,  13,  13,  13,  14,  14,  14,  15,  15,  15,  13,  13,  13,
    14,  14,  14,  15,  15,  15,  13,  13,  13,  14,  14,  14,  15,  15,  15,  13,  13,
    13,  14,  14,  14,  15,  15,  15,  10,  10,  10,  11,  11,  11,  12,  12,  12,  10,
    10,  10,  11,  11,  11,  12,  12,  12,  10,  10,  10,  11,  11,  11,  12,  12,  12,
    10,  10,  10,  11,  11,  11,  12,  12,  12,   7,   7,   7,   7,   8,   8,   8,   8,
    9,   9,   9,   9,   7,   7,   7,   7,   8,   8,   8,   8,   9,   9,   9,   9,   7,
    7,   7,   7,   8,   8,   8,   8,   9,   9,   9,   9,   7,   7,   7,   7,   8,   8,
    8,   8,   9,   9,   9,   9,   7,   7,   7,   7,   8,   8,   8,   8,   9,   9,   9,
    9,   3,   3,   3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6,   6,   6,
    3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   6,   6,
    6,   6,   6,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   5,   5,
    5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   3,   3,   3,   3,   3,   3,   3,
    4,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,
    6,   6,   6,   6,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,
    4,   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,
    6,   6,   2,   2,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,
    1,   0,   0,   0,   0,   0,   0,   0,   0,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x009A2428 */
const uint8_t * Rotation2TimeToSpriteMaps[] = {
    Rotation2TimeToSpriteMap_0,
    Rotation2TimeToSpriteMap_1,
    Rotation2TimeToSpriteMap_2,
};

/** rct2: 0x0099EB28 */
static constexpr const uint8_t Rotation3TimeToSpriteMap_0[] = {
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
    1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
    2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
    3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
    4,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,
    6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,
    7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,
    9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,
    10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,
    13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,
    15,  15,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,
    19,  19,  19,  19,  19,  20,  20,  20,  20,  21,  21,  21,  21,  22,  22,  22,  22,
    23,  23,  23,  23,  24,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  27,  28,
    28,  28,  29,  29,  29,  30,  30,  30,  31,  31,  31,  32,  32,  32,  33,  33,  33,
    34,  34,  34,  35,  35,  35,  36,  36,  36,  37,  37,  37,  38,  38,  38,  39,  39,
    39,  40,  40,  40,  41,  41,  41,  42,  42,  42,  43,  43,  43,  44,  44,  44,  45,
    45,  45,  46,  46,  46,  47,  47,  47,  48,  48,  48,  49,  49,  49,  50,  50,  50,
    51,  51,  51,  52,  52,  52,  53,  53,  53,  54,  54,  54,  55,  55,  55,  56,  56,
    56,  57,  57,  57,  58,  58,  58,  59,  59,  59,  60,  60,  60,  61,  61,  61,  62,
    62,  62,  63,  63,  63,  64,  64,  64,  65,  65,  65,  66,  66,  66,  67,  67,  67,
    68,  68,  68,  69,  69,  69,  70,  70,  70,  71,  71,  71,  72,  72,  72,  73,  73,
    73,  74,  74,  74,  75,  75,  75,  76,  76,  76,  77,  77,  77,  78,  78,  78,  79,
    79,  79,  80,  80,  80,  81,  81,  81,  82,  82,  82,  83,  83,  83,  84,  84,  84,
    85,  85,  85,  86,  86,  86,  87,  87,  87,  88,  88,  88,  89,  89,  89,  90,  90,
    90,  91,  91,  91,  92,  92,  92,  93,  93,  93,  94,  94,  94,  95,  95,  95,  96,
    96,  96,  97,  97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101,
    102, 102, 102, 103, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 106, 107, 107,
    107, 108, 108, 108, 109, 109, 109, 110, 110, 110, 111, 111, 111, 112, 112, 112, 113,
    113, 113, 114, 114, 114, 115, 115, 115, 116, 116, 116, 117, 117, 117, 118, 118, 118,
    119, 119, 119, 120, 120, 120, 121, 121, 121, 122, 122, 122, 123, 123, 123, 124, 124,
    124, 125, 125, 125, 126, 126, 126, 127, 127, 127,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x0099ED49 */
static constexpr const uint8_t Rotation3TimeToSpriteMap_1[] = {
    0,   0,   0,   1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,
    5,   6,   6,   6,   7,   7,   7,   8,   8,   8,   9,   9,   9,  10,  10,  10,  11,
    11,  11,  12,  12,  12,  13,  13,  13,  14,  14,  14,  15,  15,  15,  16,  16,  16,
    17,  17,  17,  18,  18,  18,  19,  19,  19,  20,  20,  20,  21,  21,  21,  22,  22,
    22,  23,  23,  23,  24,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  27,  28,
    28,  28,  29,  29,  29,  30,  30,  30,  31,  31,  31,  32,  32,  32,  33,  33,  33,
    34,  34,  34,  35,  35,  35,  36,  36,  36,  37,  37,  37,  38,  38,  38,  39,  39,
    39,  40,  40,  40,  41,  41,  41,  42,  42,  42,  43,  43,  43,  44,  44,  44,  45,
    45,  45,  46,  46,  46,  47,  47,  47,  48,  48,  48,  49,  49,  49,  50,  50,  50,
    51,  51,  51,  52,  52,  52,  53,  53,  53,  54,  54,  54,  55,  55,  55,  56,  56,
    56,  57,  57,  57,  58,  58,  58,  59,  59,  59,  60,  60,  60,  61,  61,  61,  62,
    62,  62,  63,  63,  63,  64,  64,  64,  65,  65,  65,  66,  66,  66,  67,  67,  67,
    68,  68,  68,  69,  69,  69,  70,  70,  70,  71,  71,  71,  72,  72,  72,  73,  73,
    73,  74,  74,  74,  75,  75,  75,  76,  76,  76,  77,  77,  77,  78,  78,  78,  79,
    79,  79,  80,  80,  80,  81,  81,  81,  82,  82,  82,  83,  83,  83,  84,  84,  84,
    85,  85,  85,  86,  86,  86,  87,  87,  87,  88,  88,  88,  89,  89,  89,  90,  90,
    90,  91,  91,  91,  92,  92,  92,  93,  93,  93,  94,  94,  94,  95,  95,  95,  96,
    96,  96,  97,  97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101,
    102, 102, 102, 103, 103, 103, 104, 104, 104, 105, 105, 105, 106, 106, 106, 107, 107,
    107, 108, 108, 108, 109, 109, 109, 110, 110, 110, 111, 111, 111, 112, 112, 112, 113,
    113, 113, 114, 114, 114, 115, 115, 115, 116, 116, 116, 117, 117, 117, 118, 118, 118,
    119, 119, 119, 120, 120, 120, 121, 121, 121, 122, 122, 122, 123, 123, 123, 124, 124,
    124, 125, 125, 125, 126, 126, 126, 127, 127, 127,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x0099EED1 */
static constexpr const uint8_t Rotation3TimeToSpriteMap_2[] = {
    0,   0,   0,   1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,
    5,   6,   6,   6,   7,   7,   7,   8,   8,   8,   9,   9,   9,  10,  10,  10,  11,
    11,  11,  12,  12,  12,  13,  13,  13,  14,  14,  14,  15,  15,  15,  16,  16,  16,
    17,  17,  17,  18,  18,  18,  19,  19,  19,  20,  20,  20,  21,  21,  21,  22,  22,
    22,  23,  23,  23,  24,  24,  24,  25,  25,  25,  26,  26,  26,  27,  27,  27,  28,
    28,  28,  29,  29,  29,  30,  30,  30,  31,  31,  31,  32,  32,  32,  33,  33,  33,
    34,  34,  34,  35,  35,  35,  36,  36,  36,  37,  37,  37,  38,  38,  38,  39,  39,
    39,  40,  40,  40,  41,  41,  41,  42,  42,  42,  43,  43,  43,  44,  44,  44,  45,
    45,  45,  46,  46,  46,  47,  47,  47,  48,  48,  48,  49,  49,  49,  50,  50,  50,
    51,  51,  51,  52,  52,  52,  53,  53,  53,  54,  54,  54,  55,  55,  55,  56,  56,
    56,  57,  57,  57,  58,  58,  58,  59,  59,  59,  60,  60,  60,  61,  61,  61,  62,
    62,  62,  63,  63,  63,  64,  64,  64,  65,  65,  65,  66,  66,  66,  67,  67,  67,
    68,  68,  68,  69,  69,  69,  70,  70,  70,  71,  71,  71,  72,  72,  72,  73,  73,
    73,  74,  74,  74,  75,  75,  75,  76,  76,  76,  77,  77,  77,  78,  78,  78,  79,
    79,  79,  80,  80,  80,  81,  81,  81,  82,  82,  82,  83,  83,  83,  84,  84,  84,
    85,  85,  85,  86,  86,  86,  87,  87,  87,  88,  88,  88,  89,  89,  89,  90,  90,
    90,  91,  91,  91,  92,  92,  92,  93,  93,  93,  94,  94,  94,  95,  95,  95,  96,
    96,  96,  97,  97,  97,  98,  98,  98,  99,  99,  99, 100, 100, 100, 101, 101, 101,
    102, 102, 102, 103, 103, 103, 103, 103, 103, 103, 104, 104, 104, 104, 105, 105, 105,
    105, 106, 106, 106, 106, 107, 107, 107, 107, 107, 108, 108, 108, 108, 108, 109, 109,
    109, 109, 109, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111, 112, 112, 112,
    112, 112, 112, 113, 113, 113, 113, 113, 113, 113, 114, 114, 114, 114, 114, 114, 114,
    115, 115, 115, 115, 115, 115, 115, 115, 116, 116, 116, 116, 116, 116, 116, 116, 116,
    117, 117, 117, 117, 117, 117, 117, 117, 117, 117, 118, 118, 118, 118, 118, 118, 118,
    118, 118, 118, 118, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 121, 121,
    121, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 122,
    122, 122, 122, 122, 122, 122, 122, 123, 123, 123, 123, 123, 123, 123, 123, 123, 123,
    123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
    124, 124, 124, 124, 124, 124, 125, 125, 125, 125, 125, 125, 125, 125, 125, 125, 125,
    125, 125, 125, 125, 125, 125, 125, 126, 126, 126, 126, 126, 126, 126, 126, 126, 126,
    126, 126, 126, 126, 126, 126, 126, 126, 126, 126,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

/** rct2: 0x0099EB1C */
const uint8_t * Rotation3TimeToSpriteMaps[] = {
    Rotation3TimeToSpriteMap_0,
    Rotation3TimeToSpriteMap_1,
    Rotation3TimeToSpriteMap_2,
};

/** rct2: 0x009A12EC */
static constexpr const TopSpinTimeToSpriteMap TopSpinTimeToSpriteMap_0[] = {
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    {  0,  0 }, {  0,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 },
    {  1,  0 }, {  1,  0 }, {  1,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 },
    {  2,  0 }, {  2,  0 }, {  2,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 },
    {  3,  0 }, {  3,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 },
    {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  6,  0 }, {  6,  0 },
    {  6,  0 }, {  6,  0 }, {  6,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 },
    {  7,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  9,  0 },
    {  9,  0 }, {  9,  0 }, {  9,  0 }, {  9,  0 }, { 10,  0 }, { 10,  0 }, { 10,  0 },
    { 10,  0 }, { 10,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 },
    { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 13,  0 }, { 13,  0 },
    { 13,  0 }, { 13,  0 }, { 13,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 },
    { 14,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 16,  0 },
    { 16,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 },
    { 17,  0 }, { 17,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 },
    { 19,  0 }, { 19,  0 }, { 19,  0 }, { 19,  0 }, { 19,  0 }, { 20,  0 }, { 20,  0 },
    { 20,  0 }, { 20,  0 }, { 20,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 },
    { 21,  0 }, { 21,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 },
    { 22,  0 }, { 22,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 },
    { 23,  0 }, { 23,  0 }, { 23,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 23,  1 },
    { 23,  1 }, { 23,  1 }, { 23,  1 }, { 23,  1 }, { 23,  1 }, { 23,  1 }, { 23,  1 },
    { 22,  2 }, { 22,  2 }, { 22,  2 }, { 22,  2 }, { 22,  2 }, { 22,  2 }, { 22,  2 },
    { 21,  3 }, { 21,  3 }, { 21,  3 }, { 21,  3 }, { 21,  3 }, { 21,  3 }, { 20,  4 },
    { 20,  4 }, { 20,  4 }, { 20,  4 }, { 20,  4 }, { 19,  5 }, { 19,  5 }, { 19,  5 },
    { 19,  5 }, { 19,  5 }, { 18,  6 }, { 18,  6 }, { 18,  6 }, { 18,  6 }, { 18,  6 },
    { 17,  7 }, { 17,  7 }, { 17,  7 }, { 17,  7 }, { 17,  7 }, { 16,  8 }, { 16,  8 },
    { 16,  8 }, { 16,  8 }, { 16,  8 }, { 15,  9 }, { 15,  9 }, { 15,  9 }, { 15,  9 },
    { 15,  9 }, { 14, 10 }, { 14, 10 }, { 14, 10 }, { 14, 10 }, { 14, 10 }, { 13, 11 },
    { 13, 11 }, { 13, 11 }, { 13, 11 }, { 13, 11 }, { 12, 12 }, { 12, 12 }, { 12, 12 },
    { 12, 12 }, { 12, 12 }, { 11, 13 }, { 11, 13 }, { 11, 13 }, { 11, 13 }, { 11, 13 },
    { 10, 14 }, { 10, 14 }, { 10, 14 }, { 10, 14 }, { 10, 14 }, {  9, 15 }, {  9, 15 },
    {  9, 15 }, {  9, 15 }, {  9, 15 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 },
    {  8,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  6,  0 },
    {  6,  0 }, {  6,  0 }, {  6,  0 }, {  6,  0 }, {  5, 15 }, {  5, 15 }, {  5, 15 },
    {  5, 15 }, {  5, 15 }, {  4, 14 }, {  4, 14 }, {  4, 14 }, {  4, 14 }, {  4, 14 },
    {  3, 13 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  2, 12 }, {  2, 12 },
    {  2, 12 }, {  2, 12 }, {  2, 12 }, {  1, 12 }, {  1, 12 }, {  1, 12 }, {  1, 12 },
    {  1, 12 }, {  0, 13 }, {  0, 13 }, {  0, 13 }, {  0, 13 }, {  0, 13 }, { 47, 14 },
    { 47, 14 }, { 47, 14 }, { 47, 14 }, { 47, 14 }, { 46, 15 }, { 46, 15 }, { 46, 15 },
    { 46, 15 }, { 46, 15 }, { 45,  0 }, { 45,  0 }, { 45,  0 }, { 45,  0 }, { 45,  0 },
    { 44,  1 }, { 44,  1 }, { 44,  1 }, { 44,  1 }, { 44,  1 }, { 43,  2 }, { 43,  2 },
    { 43,  2 }, { 43,  2 }, { 43,  2 }, { 42,  3 }, { 42,  3 }, { 42,  3 }, { 42,  3 },
    { 42,  3 }, { 41,  4 }, { 41,  4 }, { 41,  4 }, { 41,  4 }, { 41,  4 }, { 40,  5 },
    { 40,  5 }, { 40,  5 }, { 40,  5 }, { 40,  5 }, { 39,  6 }, { 39,  6 }, { 39,  6 },
    { 39,  6 }, { 39,  6 }, { 38,  7 }, { 38,  7 }, { 38,  7 }, { 38,  7 }, { 38,  7 },
    { 37,  8 }, { 37,  8 }, { 37,  8 }, { 37,  8 }, { 37,  8 }, { 36,  9 }, { 36,  9 },
    { 36,  9 }, { 36,  9 }, { 36,  9 }, { 35, 10 }, { 35, 10 }, { 35, 10 }, { 35, 10 },
    { 35, 10 }, { 34, 11 }, { 34, 11 }, { 34, 11 }, { 34, 11 }, { 34, 11 }, { 33, 12 },
    { 33, 12 }, { 33, 12 }, { 33, 12 }, { 33, 12 }, { 32, 13 }, { 32, 13 }, { 32, 13 },
    { 32, 13 }, { 32, 13 }, { 31, 14 }, { 31, 14 }, { 31, 14 }, { 31, 14 }, { 31, 14 },
    { 30, 15 }, { 30, 15 }, { 30, 15 }, { 30, 15 }, { 30, 15 }, { 29,  0 }, { 29,  0 },
    { 29,  0 }, { 29,  0 }, { 29,  0 }, { 28,  1 }, { 28,  1 }, { 28,  1 }, { 28,  1 },
    { 28,  1 }, { 27,  2 }, { 27,  2 }, { 27,  2 }, { 27,  2 }, { 27,  2 }, { 26,  3 },
    { 26,  3 }, { 26,  3 }, { 26,  3 }, { 26,  3 }, { 25,  3 }, { 25,  3 }, { 25,  3 },
    { 25,  3 }, { 25,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 },
    { 23,  2 }, { 23,  2 }, { 23,  2 }, { 23,  2 }, { 23,  2 }, { 22,  1 }, { 22,  1 },
    { 22,  1 }, { 22,  1 }, { 22,  1 }, { 22,  1 }, { 21,  0 }, { 21,  0 }, { 21,  0 },
    { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 20,  0 }, { 20,  0 }, { 20,  0 },
    { 20,  0 }, { 20,  0 }, { 20,  0 }, { 20,  0 }, { 20,  0 }, { 20,  0 }, { 21,  0 },
    { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 22,  0 },
    { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 23,  0 }, { 23,  0 },
    { 23,  0 }, { 23,  0 }, { 23,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 },
    { 24,  0 }, { 25,  0 }, { 25,  0 }, { 25,  0 }, { 25,  0 }, { 25,  0 }, { 26,  0 },
    { 26,  0 }, { 26,  0 }, { 26,  0 }, { 26,  0 }, { 27,  0 }, { 27,  0 }, { 27,  0 },
    { 27,  0 }, { 27,  0 }, { 28,  0 }, { 28,  0 }, { 28,  0 }, { 28,  0 }, { 28,  0 },
    { 29,  0 }, { 29,  0 }, { 29,  0 }, { 29,  0 }, { 29,  0 }, { 30,  0 }, { 30,  0 },
    { 30,  0 }, { 30,  0 }, { 30,  0 }, { 31,  0 }, { 31,  0 }, { 31,  0 }, { 31,  0 },
    { 31,  0 }, { 32,  0 }, { 32,  0 }, { 32,  0 }, { 32,  0 }, { 32,  0 }, { 33,  0 },
    { 33,  0 }, { 33,  0 }, { 33,  0 }, { 33,  0 }, { 34,  0 }, { 34,  0 }, { 34,  0 },
    { 34,  0 }, { 34,  0 }, { 35,  0 }, { 35,  0 }, { 35,  0 }, { 35,  0 }, { 35,  0 },
    { 36,  0 }, { 36,  0 }, { 36,  0 }, { 36,  0 }, { 36,  0 }, { 37,  0 }, { 37,  0 },
    { 37,  0 }, { 37,  0 }, { 37,  0 }, { 38,  0 }, { 38,  0 }, { 38,  0 }, { 38,  0 },
    { 38,  0 }, { 39,  0 }, { 39,  0 }, { 39,  0 }, { 39,  0 }, { 39,  0 }, { 40,  0 },
    { 40,  0 }, { 40,  0 }, { 40,  0 }, { 40,  0 }, { 41,  0 }, { 41,  0 }, { 41,  0 },
    { 41,  0 }, { 41,  0 }, { 42,  0 }, { 42,  0 }, { 42,  0 }, { 42,  0 }, { 42,  0 },
    { 43,  0 }, { 43,  0 }, { 43,  0 }, { 43,  0 }, { 43,  0 }, { 44,  0 }, { 44,  0 },
    { 44,  0 }, { 44,  0 }, { 44,  0 }, { 45,  0 }, { 45,  0 }, { 45,  0 }, { 45,  0 },
    { 45,  0 }, { 46,  0 }, { 46,  0 }, { 46,  0 }, { 46,  0 }, { 46,  0 }, { 47,  0 },
    { 47,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    {  0,  0 }, {  0,  0 },
    { 0xFF, 0 },
};

/** rct2: 0x009A1751 */
static constexpr const TopSpinTimeToSpriteMap TopSpinTimeToSpriteMap_1[] = {
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    {  0,  0 }, {  0,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 },
    {  1,  0 }, {  1,  0 }, {  1,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 },
    {  2,  0 }, {  2,  0 }, {  2,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 },
    {  3,  0 }, {  3,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 },
    {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  6,  0 }, {  6,  0 },
    {  6,  0 }, {  6,  0 }, {  6,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 },
    {  7,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  9,  0 },
    {  9,  0 }, {  9,  0 }, {  9,  0 }, {  9,  0 }, { 10,  0 }, { 10,  0 }, { 10,  0 },
    { 10,  0 }, { 10,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 },
    { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 13,  0 }, { 13,  0 },
    { 13,  0 }, { 13,  0 }, { 13,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 },
    { 14,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 16,  0 },
    { 16,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 },
    { 17,  0 }, { 17,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 },
    { 19,  0 }, { 19,  0 }, { 19,  0 }, { 19,  0 }, { 19,  0 }, { 20,  0 }, { 20,  0 },
    { 20,  0 }, { 20,  0 }, { 20,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 },
    { 21,  0 }, { 21,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 },
    { 22,  0 }, { 22,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 },
    { 23,  0 }, { 23,  0 }, { 23,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  1 },
    { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  2 },
    { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  3 }, { 24,  3 },
    { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  4 }, { 24,  4 }, { 24,  4 }, { 24,  4 },
    { 24,  4 }, { 24,  5 }, { 24,  5 }, { 24,  5 }, { 24,  5 }, { 24,  5 }, { 24,  6 },
    { 24,  6 }, { 24,  6 }, { 24,  6 }, { 24,  6 }, { 24,  7 }, { 24,  7 }, { 24,  7 },
    { 24,  7 }, { 24,  7 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 },
    { 24,  9 }, { 24,  9 }, { 24,  9 }, { 24,  9 }, { 24,  9 }, { 24, 10 }, { 24, 10 },
    { 24, 10 }, { 24, 10 }, { 24, 10 }, { 24, 11 }, { 24, 11 }, { 24, 11 }, { 24, 11 },
    { 24, 11 }, { 24, 12 }, { 24, 12 }, { 24, 12 }, { 24, 12 }, { 24, 12 }, { 24, 13 },
    { 24, 13 }, { 24, 13 }, { 24, 13 }, { 24, 13 }, { 24, 14 }, { 24, 14 }, { 24, 14 },
    { 24, 14 }, { 24, 14 }, { 24, 15 }, { 24, 15 }, { 24, 15 }, { 24, 15 }, { 24, 15 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  1 }, { 24,  1 },
    { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  2 },
    { 24,  2 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 23,  4 },
    { 23,  4 }, { 23,  4 }, { 23,  4 }, { 23,  4 }, { 22,  4 }, { 22,  4 }, { 22,  4 },
    { 22,  4 }, { 22,  4 }, { 21,  4 }, { 21,  4 }, { 21,  4 }, { 21,  4 }, { 21,  4 },
    { 20,  4 }, { 20,  4 }, { 20,  4 }, { 20,  4 }, { 20,  4 }, { 19,  4 }, { 19,  4 },
    { 19,  4 }, { 19,  4 }, { 19,  4 }, { 18,  4 }, { 18,  4 }, { 18,  4 }, { 18,  4 },
    { 18,  4 }, { 17,  4 }, { 17,  4 }, { 17,  4 }, { 17,  4 }, { 17,  4 }, { 16,  4 },
    { 16,  4 }, { 16,  4 }, { 16,  4 }, { 16,  4 }, { 15,  4 }, { 15,  4 }, { 15,  4 },
    { 15,  4 }, { 15,  4 }, { 14,  5 }, { 14,  5 }, { 14,  5 }, { 14,  5 }, { 14,  5 },
    { 13,  6 }, { 13,  6 }, { 13,  6 }, { 13,  6 }, { 13,  6 }, { 12,  7 }, { 12,  7 },
    { 12,  7 }, { 12,  7 }, { 12,  7 }, { 12,  8 }, { 12,  8 }, { 12,  8 }, { 12,  8 },
    { 12,  8 }, { 12,  9 }, { 12,  9 }, { 12,  9 }, { 12,  9 }, { 12,  9 }, { 12, 10 },
    { 12, 10 }, { 12, 10 }, { 12, 10 }, { 12, 10 }, { 12, 11 }, { 12, 11 }, { 12, 11 },
    { 12, 11 }, { 12, 11 }, { 12, 12 }, { 12, 12 }, { 12, 12 }, { 12, 12 }, { 12, 12 },
    { 13, 12 }, { 13, 12 }, { 13, 12 }, { 13, 12 }, { 13, 12 }, { 14, 12 }, { 14, 12 },
    { 14, 12 }, { 14, 12 }, { 14, 12 }, { 15, 12 }, { 15, 12 }, { 15, 12 }, { 15, 12 },
    { 15, 12 }, { 16, 12 }, { 16, 12 }, { 16, 12 }, { 16, 12 }, { 16, 12 }, { 17, 12 },
    { 17, 12 }, { 17, 12 }, { 17, 12 }, { 17, 12 }, { 18, 12 }, { 18, 12 }, { 18, 12 },
    { 18, 12 }, { 18, 12 }, { 19, 12 }, { 19, 12 }, { 19, 12 }, { 19, 12 }, { 19, 12 },
    { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 21, 13 }, { 21, 13 },
    { 21, 13 }, { 21, 13 }, { 21, 13 }, { 22, 14 }, { 22, 14 }, { 22, 14 }, { 22, 14 },
    { 22, 14 }, { 23, 15 }, { 23, 15 }, { 23, 15 }, { 23, 15 }, { 23, 15 }, { 24,  0 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 25,  1 }, { 25,  1 }, { 25,  1 },
    { 25,  1 }, { 25,  1 }, { 26,  2 }, { 26,  2 }, { 26,  2 }, { 26,  2 }, { 26,  2 },
    { 27,  3 }, { 27,  3 }, { 27,  3 }, { 27,  3 }, { 27,  3 }, { 28,  4 }, { 28,  4 },
    { 28,  4 }, { 28,  4 }, { 28,  4 }, { 29,  5 }, { 29,  5 }, { 29,  5 }, { 29,  5 },
    { 29,  5 }, { 30,  6 }, { 30,  6 }, { 30,  6 }, { 30,  6 }, { 30,  6 }, { 31,  7 },
    { 31,  7 }, { 31,  7 }, { 31,  7 }, { 31,  7 }, { 32,  8 }, { 32,  8 }, { 32,  8 },
    { 32,  8 }, { 32,  8 }, { 33,  9 }, { 33,  9 }, { 33,  9 }, { 33,  9 }, { 33,  9 },
    { 34, 10 }, { 34, 10 }, { 34, 10 }, { 34, 10 }, { 34, 10 }, { 35, 11 }, { 35, 11 },
    { 35, 11 }, { 35, 11 }, { 35, 11 }, { 36, 12 }, { 36, 12 }, { 36, 12 }, { 36, 12 },
    { 36, 12 }, { 37, 13 }, { 37, 13 }, { 37, 13 }, { 37, 13 }, { 37, 13 }, { 38, 14 },
    { 38, 14 }, { 38, 14 }, { 38, 14 }, { 38, 14 }, { 39, 15 }, { 39, 15 }, { 39, 15 },
    { 39, 15 }, { 39, 15 }, { 40,  0 }, { 40,  0 }, { 40,  0 }, { 40,  0 }, { 40,  0 },
    { 41,  0 }, { 41,  0 }, { 41,  0 }, { 41,  0 }, { 41,  0 }, { 42,  0 }, { 42,  0 },
    { 42,  0 }, { 42,  0 }, { 42,  0 }, { 43,  0 }, { 43,  0 }, { 43,  0 }, { 43,  0 },
    { 43,  0 }, { 44,  0 }, { 44,  0 }, { 44,  0 }, { 44,  0 }, { 44,  0 }, { 45,  0 },
    { 45,  0 }, { 45,  0 }, { 45,  0 }, { 45,  0 }, { 46,  0 }, { 46,  0 }, { 46,  0 },
    { 46,  0 }, { 46,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 },
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  1, 15 }, {  1, 15 },
    {  1, 15 }, {  1, 15 }, {  1, 15 }, {  2, 14 }, {  2, 14 }, {  2, 14 }, {  2, 14 },
    {  2, 14 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  4, 12 },
    {  4, 12 }, {  4, 12 }, {  4, 12 }, {  4, 12 }, {  5, 11 }, {  5, 11 }, {  5, 11 },
    {  5, 11 }, {  5, 11 }, {  6, 10 }, {  6, 10 }, {  6, 10 }, {  6, 10 }, {  6, 10 },
    {  7,  9 }, {  7,  9 }, {  7,  9 }, {  7,  9 }, {  7,  9 }, {  8,  8 }, {  8,  8 },
    {  8,  8 }, {  8,  8 }, {  8,  8 }, {  9,  7 }, {  9,  7 }, {  9,  7 }, {  9,  7 },
    {  9,  7 }, { 10,  6 }, { 10,  6 }, { 10,  6 }, { 10,  6 }, { 10,  6 }, { 11,  5 },
    { 11,  5 }, { 11,  5 }, { 11,  5 }, { 11,  5 }, { 12,  4 }, { 12,  4 }, { 12,  4 },
    { 12,  4 }, { 12,  4 }, { 13,  3 }, { 13,  3 }, { 13,  3 }, { 13,  3 }, { 13,  3 },
    { 14,  2 }, { 14,  2 }, { 14,  2 }, { 14,  2 }, { 14,  2 }, { 15,  1 }, { 15,  1 },
    { 15,  1 }, { 15,  1 }, { 15,  1 }, { 16,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 },
    { 16,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 },
    { 17,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 },
    { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 },
    { 17,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 },
    { 16,  0 }, { 16,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 },
    { 14,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 }, { 13,  0 }, { 13,  0 },
    { 13,  0 }, { 13,  0 }, { 13,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 },
    { 12,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 10,  0 },
    { 10,  0 }, { 10,  0 }, { 10,  0 }, { 10,  0 }, {  9,  0 }, {  9,  0 }, {  9,  0 },
    {  9,  0 }, {  9,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 },
    {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  6,  0 }, {  6,  0 },
    {  6,  0 }, {  6,  0 }, {  6,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 },
    {  5,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  3,  0 },
    {  3,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 },
    {  2,  0 }, {  2,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 },
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    { 0xFF, 0 },
};

/** rct2: 0x009A1CC6 */
static constexpr const TopSpinTimeToSpriteMap TopSpinTimeToSpriteMap_2[] = {
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    {  0,  0 }, {  0,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 }, {  1,  0 },
    {  1,  0 }, {  1,  0 }, {  1,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 }, {  2,  0 },
    {  2,  0 }, {  2,  0 }, {  2,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 }, {  3,  0 },
    {  3,  0 }, {  3,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 },
    {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  5,  0 }, {  6,  0 }, {  6,  0 },
    {  6,  0 }, {  6,  0 }, {  6,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 }, {  7,  0 },
    {  7,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  8,  0 }, {  9,  0 },
    {  9,  0 }, {  9,  0 }, {  9,  0 }, {  9,  0 }, { 10,  0 }, { 10,  0 }, { 10,  0 },
    { 10,  0 }, { 10,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 }, { 11,  0 },
    { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 12,  0 }, { 13,  0 }, { 13,  0 },
    { 13,  0 }, { 13,  0 }, { 13,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 }, { 14,  0 },
    { 14,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 15,  0 }, { 16,  0 },
    { 16,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 }, { 17,  0 }, { 17,  0 }, { 17,  0 },
    { 17,  0 }, { 17,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 }, { 18,  0 },
    { 19,  0 }, { 19,  0 }, { 19,  0 }, { 19,  0 }, { 19,  0 }, { 20,  0 }, { 20,  0 },
    { 20,  0 }, { 20,  0 }, { 20,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 }, { 21,  0 },
    { 21,  0 }, { 21,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 }, { 22,  0 },
    { 22,  0 }, { 22,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 }, { 23,  0 },
    { 23,  0 }, { 23,  0 }, { 23,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  1 },
    { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  2 },
    { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  3 }, { 24,  3 },
    { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  4 }, { 24,  4 }, { 24,  4 }, { 24,  4 },
    { 24,  4 }, { 24,  5 }, { 24,  5 }, { 24,  5 }, { 24,  5 }, { 24,  5 }, { 24,  6 },
    { 24,  6 }, { 24,  6 }, { 24,  6 }, { 24,  6 }, { 24,  7 }, { 24,  7 }, { 24,  7 },
    { 24,  7 }, { 24,  7 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 },
    { 24,  9 }, { 24,  9 }, { 24,  9 }, { 24,  9 }, { 24,  9 }, { 24, 10 }, { 24, 10 },
    { 24, 10 }, { 24, 10 }, { 24, 10 }, { 24, 11 }, { 24, 11 }, { 24, 11 }, { 24, 11 },
    { 24, 11 }, { 24, 12 }, { 24, 12 }, { 24, 12 }, { 24, 12 }, { 24, 12 }, { 24, 13 },
    { 24, 13 }, { 24, 13 }, { 24, 13 }, { 24, 13 }, { 24, 14 }, { 24, 14 }, { 24, 14 },
    { 24, 14 }, { 24, 14 }, { 24, 15 }, { 24, 15 }, { 24, 15 }, { 24, 15 }, { 24, 15 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  1 }, { 24,  1 },
    { 24,  1 }, { 24,  1 }, { 24,  1 }, { 24,  2 }, { 24,  2 }, { 24,  2 }, { 24,  2 },
    { 24,  2 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 24,  3 }, { 23,  4 },
    { 23,  4 }, { 23,  4 }, { 23,  4 }, { 23,  4 }, { 22,  4 }, { 22,  4 }, { 22,  4 },
    { 22,  4 }, { 22,  4 }, { 21,  4 }, { 21,  4 }, { 21,  4 }, { 21,  4 }, { 21,  4 },
    { 20,  4 }, { 20,  4 }, { 20,  4 }, { 20,  4 }, { 20,  4 }, { 19,  4 }, { 19,  4 },
    { 19,  4 }, { 19,  4 }, { 19,  4 }, { 18,  4 }, { 18,  4 }, { 18,  4 }, { 18,  4 },
    { 18,  4 }, { 17,  4 }, { 17,  4 }, { 17,  4 }, { 17,  4 }, { 17,  4 }, { 16,  4 },
    { 16,  4 }, { 16,  4 }, { 16,  4 }, { 16,  4 }, { 15,  4 }, { 15,  4 }, { 15,  4 },
    { 15,  4 }, { 15,  4 }, { 14,  5 }, { 14,  5 }, { 14,  5 }, { 14,  5 }, { 14,  5 },
    { 13,  6 }, { 13,  6 }, { 13,  6 }, { 13,  6 }, { 13,  6 }, { 12,  7 }, { 12,  7 },
    { 12,  7 }, { 12,  7 }, { 12,  7 }, { 12,  8 }, { 12,  8 }, { 12,  8 }, { 12,  8 },
    { 12,  8 }, { 12,  9 }, { 12,  9 }, { 12,  9 }, { 12,  9 }, { 12,  9 }, { 12, 10 },
    { 12, 10 }, { 12, 10 }, { 12, 10 }, { 12, 10 }, { 12, 11 }, { 12, 11 }, { 12, 11 },
    { 12, 11 }, { 12, 11 }, { 12, 12 }, { 12, 12 }, { 12, 12 }, { 12, 12 }, { 12, 12 },
    { 13, 12 }, { 13, 12 }, { 13, 12 }, { 13, 12 }, { 13, 12 }, { 14, 12 }, { 14, 12 },
    { 14, 12 }, { 14, 12 }, { 14, 12 }, { 15, 12 }, { 15, 12 }, { 15, 12 }, { 15, 12 },
    { 15, 12 }, { 16, 12 }, { 16, 12 }, { 16, 12 }, { 16, 12 }, { 16, 12 }, { 17, 12 },
    { 17, 12 }, { 17, 12 }, { 17, 12 }, { 17, 12 }, { 18, 12 }, { 18, 12 }, { 18, 12 },
    { 18, 12 }, { 18, 12 }, { 19, 12 }, { 19, 12 }, { 19, 12 }, { 19, 12 }, { 19, 12 },
    { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 21, 13 }, { 21, 13 },
    { 21, 13 }, { 21, 13 }, { 21, 13 }, { 22, 14 }, { 22, 14 }, { 22, 14 }, { 22, 14 },
    { 22, 14 }, { 23, 15 }, { 23, 15 }, { 23, 15 }, { 23, 15 }, { 23, 15 }, { 24,  0 },
    { 24,  0 }, { 24,  0 }, { 24,  0 }, { 24,  0 }, { 25,  1 }, { 25,  1 }, { 25,  1 },
    { 25,  1 }, { 25,  1 }, { 26,  2 }, { 26,  2 }, { 26,  2 }, { 26,  2 }, { 26,  2 },
    { 27,  3 }, { 27,  3 }, { 27,  3 }, { 27,  3 }, { 27,  3 }, { 28,  4 }, { 28,  4 },
    { 28,  4 }, { 28,  4 }, { 28,  4 }, { 29,  5 }, { 29,  5 }, { 29,  5 }, { 29,  5 },
    { 29,  5 }, { 30,  6 }, { 30,  6 }, { 30,  6 }, { 30,  6 }, { 30,  6 }, { 31,  7 },
    { 31,  7 }, { 31,  7 }, { 31,  7 }, { 31,  7 }, { 32,  8 }, { 32,  8 }, { 32,  8 },
    { 32,  8 }, { 32,  8 }, { 33,  9 }, { 33,  9 }, { 33,  9 }, { 33,  9 }, { 33,  9 },
    { 34, 10 }, { 34, 10 }, { 34, 10 }, { 34, 10 }, { 34, 10 }, { 35, 11 }, { 35, 11 },
    { 35, 11 }, { 35, 11 }, { 35, 11 }, { 36, 12 }, { 36, 12 }, { 36, 12 }, { 36, 12 },
    { 36, 12 }, { 37, 13 }, { 37, 13 }, { 37, 13 }, { 37, 13 }, { 37, 13 }, { 38, 14 },
    { 38, 14 }, { 38, 14 }, { 38, 14 }, { 38, 14 }, { 39, 15 }, { 39, 15 }, { 39, 15 },
    { 39, 15 }, { 39, 15 }, { 40,  0 }, { 40,  0 }, { 40,  0 }, { 40,  0 }, { 40,  0 },
    { 41,  0 }, { 41,  0 }, { 41,  0 }, { 41,  0 }, { 41,  0 }, { 42,  0 }, { 42,  0 },
    { 42,  0 }, { 42,  0 }, { 42,  0 }, { 43,  0 }, { 43,  0 }, { 43,  0 }, { 43,  0 },
    { 43,  0 }, { 44,  0 }, { 44,  0 }, { 44,  0 }, { 44,  0 }, { 44,  0 }, { 45,  0 },
    { 45,  0 }, { 45,  0 }, { 45,  0 }, { 45,  0 }, { 46,  0 }, { 46,  0 }, { 46,  0 },
    { 46,  0 }, { 46,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 }, { 47,  0 },
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  1, 15 }, {  1, 15 },
    {  1, 15 }, {  1, 15 }, {  1, 15 }, {  2, 14 }, {  2, 14 }, {  2, 14 }, {  2, 14 },
    {  2, 14 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  3, 13 }, {  4, 12 },
    {  4, 12 }, {  4, 12 }, {  4, 12 }, {  4, 12 }, {  5, 11 }, {  5, 11 }, {  5, 11 },
    {  5, 11 }, {  5, 11 }, {  6, 10 }, {  6, 10 }, {  6, 10 }, {  6, 10 }, {  6, 10 },
    {  7,  9 }, {  7,  9 }, {  7,  9 }, {  7,  9 }, {  7,  9 }, {  8,  8 }, {  8,  8 },
    {  8,  8 }, {  8,  8 }, {  8,  8 }, {  9,  7 }, {  9,  7 }, {  9,  7 }, {  9,  7 },
    {  9,  7 }, { 10,  6 }, { 10,  6 }, { 10,  6 }, { 10,  6 }, { 10,  6 }, { 11,  5 },
    { 11,  5 }, { 11,  5 }, { 11,  5 }, { 11,  5 }, { 12,  4 }, { 12,  4 }, { 12,  4 },
    { 12,  4 }, { 12,  4 }, { 13,  3 }, { 13,  3 }, { 13,  3 }, { 13,  3 }, { 13,  3 },
    { 14,  2 }, { 14,  2 }, { 14,  2 }, { 14,  2 }, { 14,  2 }, { 15,  1 }, { 15,  1 },
    { 15,  1 }, { 15,  1 }, { 15,  1 }, { 16,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 },
    { 16,  0 }, { 17, 15 }, { 17, 15 }, { 17, 15 }, { 17, 15 }, { 17, 15 }, { 18, 14 },
    { 18, 14 }, { 18, 14 }, { 18, 14 }, { 18, 14 }, { 19, 13 }, { 19, 13 }, { 19, 13 },
    { 19, 13 }, { 19, 13 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 },
    { 21, 11 }, { 21, 11 }, { 21, 11 }, { 21, 11 }, { 21, 11 }, { 22, 10 }, { 22, 10 },
    { 22, 10 }, { 22, 10 }, { 22, 10 }, { 23,  9 }, { 23,  9 }, { 23,  9 }, { 23,  9 },
    { 23,  9 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 25,  7 },
    { 25,  7 }, { 25,  7 }, { 25,  7 }, { 25,  7 }, { 26,  6 }, { 26,  6 }, { 26,  6 },
    { 26,  6 }, { 26,  6 }, { 27,  5 }, { 27,  5 }, { 27,  5 }, { 27,  5 }, { 27,  5 },
    { 28,  4 }, { 28,  4 }, { 28,  4 }, { 28,  4 }, { 28,  4 }, { 29,  3 }, { 29,  3 },
    { 29,  3 }, { 29,  3 }, { 29,  3 }, { 30,  2 }, { 30,  2 }, { 30,  2 }, { 30,  2 },
    { 30,  2 }, { 31,  1 }, { 31,  1 }, { 31,  1 }, { 31,  1 }, { 31,  1 }, { 32,  0 },
    { 32,  0 }, { 32,  0 }, { 32,  0 }, { 32,  0 }, { 33, 15 }, { 33, 15 }, { 33, 15 },
    { 33, 15 }, { 33, 15 }, { 34, 14 }, { 34, 14 }, { 34, 14 }, { 34, 14 }, { 34, 14 },
    { 35, 13 }, { 35, 13 }, { 35, 13 }, { 35, 13 }, { 35, 13 }, { 36, 12 }, { 36, 12 },
    { 36, 12 }, { 36, 12 }, { 36, 12 }, { 37, 11 }, { 37, 11 }, { 37, 11 }, { 37, 11 },
    { 37, 11 }, { 38, 10 }, { 38, 10 }, { 38, 10 }, { 38, 10 }, { 38, 10 }, { 39,  9 },
    { 39,  9 }, { 39,  9 }, { 39,  9 }, { 39,  9 }, { 40,  8 }, { 40,  8 }, { 40,  8 },
    { 40,  8 }, { 40,  8 }, { 41,  8 }, { 41,  8 }, { 41,  8 }, { 41,  8 }, { 41,  8 },
    { 41,  8 }, { 41,  8 }, { 42,  8 }, { 42,  8 }, { 42,  8 }, { 42,  8 }, { 42,  8 },
    { 42,  8 }, { 42,  8 }, { 42,  8 }, { 42,  8 }, { 42,  8 }, { 41,  8 }, { 41,  8 },
    { 41,  8 }, { 41,  8 }, { 41,  8 }, { 41,  8 }, { 41,  8 }, { 40,  8 }, { 40,  8 },
    { 40,  8 }, { 40,  8 }, { 40,  8 }, { 39,  9 }, { 39,  9 }, { 39,  9 }, { 39,  9 },
    { 39,  9 }, { 38, 10 }, { 38, 10 }, { 38, 10 }, { 38, 10 }, { 38, 10 }, { 37, 11 },
    { 37, 11 }, { 37, 11 }, { 37, 11 }, { 37, 11 }, { 36, 12 }, { 36, 12 }, { 36, 12 },
    { 36, 12 }, { 36, 12 }, { 35, 13 }, { 35, 13 }, { 35, 13 }, { 35, 13 }, { 35, 13 },
    { 34, 14 }, { 34, 14 }, { 34, 14 }, { 34, 14 }, { 34, 14 }, { 33, 15 }, { 33, 15 },
    { 33, 15 }, { 33, 15 }, { 33, 15 }, { 32,  0 }, { 32,  0 }, { 32,  0 }, { 32,  0 },
    { 32,  0 }, { 31,  1 }, { 31,  1 }, { 31,  1 }, { 31,  1 }, { 31,  1 }, { 30,  2 },
    { 30,  2 }, { 30,  2 }, { 30,  2 }, { 30,  2 }, { 29,  3 }, { 29,  3 }, { 29,  3 },
    { 29,  3 }, { 29,  3 }, { 28,  4 }, { 28,  4 }, { 28,  4 }, { 28,  4 }, { 28,  4 },
    { 27,  5 }, { 27,  5 }, { 27,  5 }, { 27,  5 }, { 27,  5 }, { 26,  6 }, { 26,  6 },
    { 26,  6 }, { 26,  6 }, { 26,  6 }, { 25,  7 }, { 25,  7 }, { 25,  7 }, { 25,  7 },
    { 25,  7 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 24,  8 }, { 23,  9 },
    { 23,  9 }, { 23,  9 }, { 23,  9 }, { 23,  9 }, { 22, 10 }, { 22, 10 }, { 22, 10 },
    { 22, 10 }, { 22, 10 }, { 21, 11 }, { 21, 11 }, { 21, 11 }, { 21, 11 }, { 21, 11 },
    { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 20, 12 }, { 19, 13 }, { 19, 13 },
    { 19, 13 }, { 19, 13 }, { 19, 13 }, { 18, 14 }, { 18, 14 }, { 18, 14 }, { 18, 14 },
    { 18, 14 }, { 17, 15 }, { 17, 15 }, { 17, 15 }, { 17, 15 }, { 17, 15 }, { 16,  0 },
    { 16,  0 }, { 16,  0 }, { 16,  0 }, { 16,  0 }, { 15,  1 }, { 15,  1 }, { 15,  1 },
    { 15,  1 }, { 15,  1 }, { 14,  2 }, { 14,  2 }, { 14,  2 }, { 14,  2 }, { 14,  2 },
    { 13,  3 }, { 13,  3 }, { 13,  3 }, { 13,  3 }, { 13,  3 }, { 12,  2 }, { 12,  2 },
    { 12,  2 }, { 12,  2 }, { 12,  2 }, { 11,  1 }, { 11,  1 }, { 11,  1 }, { 11,  1 },
    { 11,  1 }, { 10,  0 }, { 10,  0 }, { 10,  0 }, { 10,  0 }, { 10,  0 }, {  9, 15 },
    {  9, 15 }, {  9, 15 }, {  9, 15 }, {  9, 15 }, {  8, 14 }, {  8, 14 }, {  8, 14 },
    {  8, 14 }, {  8, 14 }, {  7, 13 }, {  7, 13 }, {  7, 13 }, {  7, 13 }, {  7, 13 },
    {  6, 14 }, {  6, 14 }, {  6, 14 }, {  6, 14 }, {  6, 14 }, {  5, 15 }, {  5, 15 },
    {  5, 15 }, {  5, 15 }, {  5, 15 }, {  4,  0 }, {  4,  0 }, {  4,  0 }, {  4,  0 },
    {  4,  0 }, {  3,  1 }, {  3,  1 }, {  3,  1 }, {  3,  1 }, {  3,  1 }, {  2,  2 },
    {  2,  2 }, {  2,  2 }, {  2,  2 }, {  2,  2 }, {  1,  1 }, {  1,  1 }, {  1,  1 },
    {  1,  1 }, {  1,  1 }, {  1,  1 }, {  1,  1 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 }, {  0,  0 },
    { 0xFF, 0 },
};

/** rct2: 0x009A12E0 */
const TopSpinTimeToSpriteMap * TopSpinTimeToSpriteMaps[] = {
    TopSpinTimeToSpriteMap_0,
    TopSpinTimeToSpriteMap_1,
    TopSpinTimeToSpriteMap_2,
};

/** rct2: 0x009A0434 */
const uint8_t MotionSimulatorTimeToSpriteMap[] = {
    0,  0,  0,  4,  4,  4,  5,  5,  5,  6,  6,  6,  7,  7,  7,  8,  8,  8,  9,  9,  9,
    10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15,
    15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 15, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 11,
    10, 10, 10, 10, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 25, 25, 25, 25, 24, 24, 24,
    24, 23, 23, 23, 23, 10, 10, 10, 10, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 31, 31, 31, 31, 30, 30, 30, 30, 29, 29, 29, 29,
    10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14,
    13, 13, 13, 12, 12, 12, 11, 11, 11, 10, 10, 10, 17, 17, 17, 18, 18, 18, 19, 19, 19,
    20, 20, 20, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 21, 21, 21, 20, 20, 20, 19, 19, 19, 18, 18, 18, 17, 17, 17, 10, 10, 10,
    11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
    11, 11, 11, 10, 10, 10,  9,  9,  8,  8,  7,  7,  6,  6,  7,  7,  8,  8,  9,  9, 29,
    29, 30, 30, 31, 31, 30, 30, 29, 29, 10, 10, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21,
    22, 22, 21, 21, 20, 20, 19, 19, 18, 18, 17, 17, 10, 10, 11, 11, 12, 12, 12, 12, 12,
    12, 12, 11, 11, 10, 10, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26,
    26, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 27, 27, 27, 27, 26, 26, 26,
    26, 25, 25, 25, 25, 24, 24, 24, 24, 23, 23, 23, 23, 10, 10, 10, 10, 29, 29, 29, 29,
    30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 29, 29, 29, 29,
    10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16,
    16, 16, 16, 16, 16, 16, 15, 15, 15, 14, 14, 14, 13, 13, 13, 12, 12, 12, 11, 11, 11,
    10, 10, 10, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 19, 19, 18, 18, 18, 17, 17, 17, 10, 10, 10,
    9,  9,  8,  8,  7,  7,  6,  6,  7,  7,  8,  8,  9,  9, 17, 17, 18, 18, 19, 19, 20,
    20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 19, 18, 18, 17, 17, 10, 10, 23, 23,
    24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 27,
    27, 26, 26, 25, 25, 24, 24, 23, 23, 10, 10, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21,
    22, 22, 22, 21, 21, 20, 20, 19, 19, 18, 18, 17, 17, 10, 10, 11, 11, 12, 12, 13, 13,
    14, 14, 15, 15, 16, 16, 16, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 29, 29,
    30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 29, 29, 10, 10,
    23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 23, 23,
    10, 10, 29, 29, 30, 30, 30, 30, 30, 30, 30, 29, 29, 10, 10, 23, 23, 24, 24, 24, 24,
    24, 24, 24, 23, 23, 10, 10, 29, 29, 30, 30, 30, 30, 30, 30, 30, 29, 29, 10, 10, 23,
    23, 24, 24, 24, 24, 24, 24, 24, 23, 23, 10, 10, 17, 17, 17, 17, 18, 18, 18, 18, 19,
    19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 20, 20, 20, 20, 19, 19, 19, 19,
    18, 18, 18, 18, 17, 17, 17, 17, 10, 10, 10, 10, 17, 17, 18, 18, 19, 19, 20, 20, 21,
    21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 21, 21, 20,
    20, 19, 19, 18, 18, 17, 17, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 14, 14, 13, 13,
    12, 12, 11, 11, 10, 10, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26,
    26, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 27, 27, 27, 27, 26, 26, 26, 26, 25, 25, 25, 25, 24, 24, 24, 24, 23, 23,
    23, 23, 10, 10, 10, 10, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32,
    32, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 33, 33, 33, 33, 32, 32, 32, 32, 31, 31, 31, 31, 30, 30, 30, 30, 29, 29,
    29, 29, 10, 10, 10, 10,  9,  9,  8,  8,  7,  7,  6,  6,  7,  7,  8,  8,  9,  9,  9,
    9,  8,  8,  7,  7,  6,  6,  7,  7,  8,  8,  9,  9,  9,  9,  8,  8,  7,  7,  6,  6,
    7,  7,  8,  8,  9,  9, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19,
    20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 19, 19,
    19, 19, 19, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 10, 10, 10, 10, 10, 23, 23, 24,
    24, 25, 25, 26, 26, 27, 27, 28, 28, 27, 27, 26, 26, 25, 25, 24, 24, 23, 23, 10, 10,
    29, 29, 30, 30, 31, 31, 32, 32, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 33, 33, 32, 32, 31,
    31, 30, 30, 29, 29, 10, 10, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 19, 19, 19, 19,
    19, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 19,
    19, 19, 19, 19, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 10, 10, 10, 10, 10, 11, 11,
    12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10,  9,  9,  8,  8,  7,
    7,  6,  6,  7,  7,  8,  8,  9,  9,  9,  9,  8,  8,  7,  7,  6,  6,  7,  7,  8,  8,
    9,  9, 23, 23, 24, 24, 25, 25, 24, 24, 23, 23, 10, 10, 29, 29, 30, 30, 31, 31, 30,
    30, 29, 29, 10, 10, 23, 23, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 24, 24, 23, 23, 10, 10, 29, 29, 30, 30, 31, 31, 31, 31, 31, 31,
    31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 30, 30, 29, 29, 10, 10, 23, 23, 24, 24,
    24, 24, 24, 24, 24, 23, 23, 10, 10, 29, 29, 30, 30, 30, 30, 30, 30, 30, 29, 29, 10,
    10, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 23,
    23, 10, 10, 29, 29, 30, 30, 31, 31, 32, 32, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34, 34, 33, 33, 32, 32, 31, 31, 30, 30, 29, 29, 10, 10,
    17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 21, 22, 22, 22, 22, 22, 22,
    22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 21, 21, 21, 20, 20, 20, 19, 19, 19,
    18, 18, 18, 17, 17, 17, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13,
    13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 15, 15, 14, 14, 14, 14,
    14, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10,
    10, 10, 10, 10,  9,  9,  9,  8,  8,  8,  7,  7,  7,  6,  6,  6,  5,  5,  5,  4,  4,
    4,  0,  0,  0,
    0xFF,
};

const int32_t MotionSimulatorTimeToSpriteMapCount = static_cast<int32_t>(std::size(MotionSimulatorTimeToSpriteMap));

/** rct2: 0x009A2930
The distance between subposition points in a movement direction (but not distance).
*/
const int32_t SubpositionTranslationDistances[] = {
    // For a base length of 8716 (0x220C) on the horizontal and 6554 (0x199A) on the vertical,
    // use the Pythagoras theorem and round up.
    0,      // no movement
    8716,   // X translation
    8716,   // Y translation
    12327,  // XY translation
    6554,   // Z translation
    10905,  // XZ translation
    10905,  // YZ translation
    13961,  // XYZ translation
    // For the reverser car, multiply the horizontal distance by 2.5 and the vertical distance by 4.072.
    0,      // no movement
    21790,  // X translation
    21790,  // Y translation
    30817,  // Z translation
    16385,  // XY translation
    27262,  // XZ translation
    27262,  // YZ translation
    34902,  // XYZ translation
};

/** rct2: 0x009A2970 */
const int32_t AccelerationFromPitch[] = {
          0,    // Flat
     // The geometric angle of slopes 12.5 and 25 are actually 11.1 and 22.2 respectively.
    -124548,    // 1 Slope Up 12.5
    -243318,    // 2 Slope Up 25
    -416016,    // 3 Slope Up 42.5
    -546342,    // 4 Slope Up 60
     124548,    // 5 Slope Down 12.5
     243318,    // 6 Slope Down 25
     416016,    // 7 Slope Down 42.5
     546342,    // 8 Slope Down 60
    -617604,    // 9 Slope Up 75
    -642000,    // 10 Slope Up 90
    -620172,    // 11 Slope Up 105
    -555972,    // 12 Slope Up 120
    -453894,    // 13 Slope Up 135
    -321000,    // 14 Slope Up 150
    -166278,    // 15 Slope Up 165
          0,    // 16 Fully Inverted
     617604,    // 17 Slope Down 75
     642000,    // 18 Slope Down 90
     620172,    // 19 Slope Down 105
     555972,    // 20 Slope Down 120
     453894,    // 21 Slope Down 135
     321000,    // 22 Slope Down 150
     166278,    // 23 Slope Down 165
    -321000,    // 24 Corkscrew Right Up 0
    -555972,    // 25 Corkscrew Right Up 1
    -642000,    // 26 Corkscrew Right Up 2
    -555972,    // 27 Corkscrew Right Up 3
    -321000,    // 28 Corkscrew Right Up 4
     321000,    // 29 Corkscrew Right Down 4
     555972,    // 30 Corkscrew Right Down 3
     642000,    // 31 Corkscrew Right Down 2
     555972,    // 32 Corkscrew Right Down 1
     321000,    // 33 Corkscrew Right Down 0
    -321000,    // 34 Corkscrew Left Up 0
    -555972,    // 35 Corkscrew Left Up 1
    -642000,    // 36 Corkscrew Left Up 2
    -555972,    // 37 Corkscrew Left Up 3
    -321000,    // 38 Corkscrew Left Up 4
     321000,    // 39 Corkscrew Left Down 4
     555972,    // 40 Corkscrew Left Down 2
     642000,    // 41 Corkscrew Left Down 1
     555972,    // 42 Corkscrew Left Down 1
     321000,    // 43 Corkscrew Left Down 0
     -33384,    // 44 Half Helix Up Large
     -55854,    // 45 Half Helix Up Small
      33384,    // 46 Half Helix Down Large
      55854,    // 47 Half Helix Down Small
     -66768,    // 48 Quarter Helix Up
      66768,    // 49 Quarter Helix Down
     // currently only diagonal elements use slopes angles 8, 16, 50. Diagonal gentle-to-steep transition uses
     // diagonal sprites of slopes 25 and 42.
     -90522,    // 50 Slope Up 8
    -179760,    // 51 Slope Down 16
    -484068,    // 52 Slope Up 50
      90522,    // 53 Slope Down 8
     179760,    // 54 Slope Down 16
     484068,    // 55 Slope Down 50
     243318,    // 56 Inverting Loop Down 25
     416016,    // 57 Inverting Loop Down 42.5
     546342,    // 58 Inverting Loop Down 60
    -110424,    // 59 Slope Up Spiral Lift Hill
};

/** rct2: 0x009A3684 */
const int32_t SpriteDirectionToSoundDirection[] = {
    -0x4000,    // 0
    -0x3000,    // 1
    -0x2000,    // 2
    -0x1000,    // 3
          0,    // 4
     0x1000,    // 5
     0x2000,    // 6
     0x3000,    // 7
     0x4000,    // 8
     0x4800,    // 9
     0x4800,    // 10
     0x4800,    // 11
     0x4800,    // 12
     0x4800,    // 13
     0x4800,    // 14
     0x4800,    // 15
     0x4000,    // 16
     0x3000,    // 17
     0x2000,    // 18
     0x1000,    // 19
          0,    // 20
    -0x1000,    // 21
    -0x2000,    // 22
    -0x3000,    // 23
    -0x4000,    // 24
    -0x4800,    // 25
    -0x4800,    // 26
    -0x4800,    // 27
    -0x4800,    // 28
    -0x4800,    // 29
    -0x4800,    // 30
    -0x4800,    // 31
};
// clang-format on
